<?php

/**
 * Class that operate on table 'rawmaterialssuppliers'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
class RawmaterialssuppliersMySqlDAO implements RawmaterialssuppliersDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RawmaterialssuppliersMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM rawmaterialssuppliers WHERE rawmaterialssupplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM rawmaterialssuppliers';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM rawmaterialssuppliers ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param rawmaterialssupplier primary key
     */
    public function delete($rawmaterialssupplierid) {
        $sql = 'DELETE FROM rawmaterialssuppliers WHERE rawmaterialssupplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($rawmaterialssupplierid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RawmaterialssuppliersMySql rawmaterialssupplier
     */
    public function insert($rawmaterialssupplier) {
        $sql = 'INSERT INTO rawmaterialssuppliers (rawmaterialssuppliername, rawmaterialssupplierdebt, rawmaterialssupplieraddress, rawmaterialssuppliertele, rawmaterialssuppliercomment, tempdelete, currentdate) VALUES (?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($rawmaterialssupplier->rawmaterialssuppliername);
        $sqlQuery->set($rawmaterialssupplier->rawmaterialssupplierdebt);
        $sqlQuery->set($rawmaterialssupplier->rawmaterialssupplieraddress);
        $sqlQuery->set($rawmaterialssupplier->rawmaterialssuppliertele);
        $sqlQuery->set($rawmaterialssupplier->rawmaterialssuppliercomment);
        $sqlQuery->setNumber($rawmaterialssupplier->tempdelete);
        $sqlQuery->set($rawmaterialssupplier->currentdate);

        $id = $this->executeInsert($sqlQuery);
        $rawmaterialssupplier->rawmaterialssupplierid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RawmaterialssuppliersMySql rawmaterialssupplier
     */
    public function update($rawmaterialssupplier) {
        $sql = 'UPDATE rawmaterialssuppliers SET rawmaterialssuppliername = ?, rawmaterialssupplierdebt = ?, rawmaterialssupplieraddress = ?, rawmaterialssuppliertele = ?, rawmaterialssuppliercomment = ?, tempdelete = ?, currentdate = ? WHERE rawmaterialssupplierid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($rawmaterialssupplier->rawmaterialssuppliername);
        $sqlQuery->set($rawmaterialssupplier->rawmaterialssupplierdebt);
        $sqlQuery->set($rawmaterialssupplier->rawmaterialssupplieraddress);
        $sqlQuery->set($rawmaterialssupplier->rawmaterialssuppliertele);
        $sqlQuery->set($rawmaterialssupplier->rawmaterialssuppliercomment);
        $sqlQuery->setNumber($rawmaterialssupplier->tempdelete);
        $sqlQuery->set($rawmaterialssupplier->currentdate);

        $sqlQuery->setNumber($rawmaterialssupplier->rawmaterialssupplierid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM rawmaterialssuppliers';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByRawmaterialssuppliername($value) {
        $sql = 'SELECT * FROM rawmaterialssuppliers WHERE rawmaterialssuppliername = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialssupplierdebt($value) {
        $sql = 'SELECT * FROM rawmaterialssuppliers WHERE rawmaterialssupplierdebt = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialssupplieraddress($value) {
        $sql = 'SELECT * FROM rawmaterialssuppliers WHERE rawmaterialssupplieraddress = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialssuppliertele($value) {
        $sql = 'SELECT * FROM rawmaterialssuppliers WHERE rawmaterialssuppliertele = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialssuppliercomment($value) {
        $sql = 'SELECT * FROM rawmaterialssuppliers WHERE rawmaterialssuppliercomment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempdelete($value) {
        $sql = 'SELECT * FROM rawmaterialssuppliers WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCurrentdate($value) {
        $sql = 'SELECT * FROM rawmaterialssuppliers WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByRawmaterialssuppliername($value) {
        $sql = 'DELETE FROM rawmaterialssuppliers WHERE rawmaterialssuppliername = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialssupplierdebt($value) {
        $sql = 'DELETE FROM rawmaterialssuppliers WHERE rawmaterialssupplierdebt = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialssupplieraddress($value) {
        $sql = 'DELETE FROM rawmaterialssuppliers WHERE rawmaterialssupplieraddress = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialssuppliertele($value) {
        $sql = 'DELETE FROM rawmaterialssuppliers WHERE rawmaterialssuppliertele = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialssuppliercomment($value) {
        $sql = 'DELETE FROM rawmaterialssuppliers WHERE rawmaterialssuppliercomment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempdelete($value) {
        $sql = 'DELETE FROM rawmaterialssuppliers WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCurrentdate($value) {
        $sql = 'DELETE FROM rawmaterialssuppliers WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RawmaterialssuppliersMySql
     */
    protected function readRow($row) {
        $rawmaterialssupplier = new Rawmaterialssupplier();

        $rawmaterialssupplier->rawmaterialssupplierid = isset($row['rawmaterialssupplierid']) ? $row['rawmaterialssupplierid'] : '';
        $rawmaterialssupplier->rawmaterialssuppliername = isset($row['rawmaterialssuppliername']) ? $row['rawmaterialssuppliername'] : '';
        $rawmaterialssupplier->rawmaterialssupplierdebt = isset($row['rawmaterialssupplierdebt']) ? $row['rawmaterialssupplierdebt'] : '';
        $rawmaterialssupplier->rawmaterialssupplieraddress = isset($row['rawmaterialssupplieraddress']) ? $row['rawmaterialssupplieraddress'] : '';
        $rawmaterialssupplier->rawmaterialssuppliertele = isset($row['rawmaterialssuppliertele']) ? $row['rawmaterialssuppliertele'] : '';
        $rawmaterialssupplier->rawmaterialssuppliercomment = isset($row['rawmaterialssuppliercomment']) ? $row['rawmaterialssuppliercomment'] : '';
        $rawmaterialssupplier->tempdelete = isset($row['tempdelete']) ? $row['tempdelete'] : '';
        $rawmaterialssupplier->currentdate = isset($row['currentdate']) ? $row['currentdate'] : '';

        return $rawmaterialssupplier;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RawmaterialssuppliersMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>